# -*- coding: utf-8 -*-
################################################################################
#
#    Cyllo Pvt. Ltd.
#
#    Copyright (C) 2023-TODAY Cyllo(<https://www.cyllo.com>).
#    Author: Ammu Raj
#
#    You can modify it under the terms of the GNU AFFERO
#    GENERAL PUBLIC LICENSE (AGPL v3), Version 3.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU AFFERO GENERAL PUBLIC LICENSE (AGPL v3) for more details.
#
#    You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE
#    (AGPL v3) along with this program.
#    If not, see <http://www.gnu.org/licenses/>.
#
################################################################################
from odoo import fields, models


class ProductBrand(models.Model):
    """Model for creating Brands for products."""
    _name = 'product.brand'
    _description = "Product Brand"
    _rec_name = 'brand_name'

    brand_name = fields.Char(required=True, string='Name', help='Name of the'
                                                                'brand.')
    sequence_no = fields.Integer(string="Sequence no", help='Sequence number of'
                                                            'brand.')
    parent_id = fields.Many2one('product.brand', string='Parent Brand',
                                index=True, help='Select the parent brand of'
                                                 'the brand.')
