# -*- coding: utf-8 -*-
#############################################################################
#
#    Cyllo.
#
#    Copyright (C) 2024-TODAY Cyllo(<https://www.cyllo.com>)
#    Author: Cyllo
#
#    You can modify it under the terms of the GNU LESSER
#    GENERAL PUBLIC LICENSE (LGPL v3), Version 3.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU LESSER GENERAL PUBLIC LICENSE (LGPL v3) for more details.
#
#    You should have received a copy of the GNU LESSER GENERAL PUBLIC LICENSE
#    (LGPL v3) along with this program.
#    If not, see <http://www.gnu.org/licenses/>.
#
#############################################################################
from odoo import models


class FugeTheme(models.AbstractModel):
    """Class FugeTheme inherited them.utils with function _fuge_theme_post_copy
    for manipulating views"""
    _inherit = 'theme.utils'

    def _fuge_theme_post_copy(self, mod):
        """Views are manipulated related to the blog post some of them are
        enabled and some of them are disabled"""
        self.enable_view('website_blog.opt_blog_sidebar_show')
        self.enable_view('website_blog.opt_blog_list_view')
        self.disable_view('website_blog.opt_posts_loop_show_author')
        self.disable_view('website_sale.add_grid_or_list_option')
        self.disable_view('website_sale.products_list_view')
