/** @odoo-module **/
/*
    POS Payment Terminal module for Odoo
    Copyright (C) 2014-2020 Aurélien DUMAINE
    Copyright (C) 2014-2020 Akretion (www.akretion.com)
    @author: Aurélien DUMAINE
    @author: Alexis de Lattre <alexis.delattre@akretion.com>
    @author: Denis Roussel <denis.roussel@acsone.eu>
    @author: Stéphane Bidoul <stephane.bidoul@acsone.eu>
    License AGPL-3.0 or later (http://www.gnu.org/licenses/agpl).
*/
import { Payment } from "@point_of_sale/app/store/models";
import { OCAPaymentTerminal } from "@pos_payment_terminal/js/payment_terminal";
import { register_payment_method } from "@point_of_sale/app/store/pos_store";
register_payment_method("oca_payment_terminal", OCAPaymentTerminal);

const PosPaymentTerminalPosGlobalState = (OriginalPosGlobalState) =>
    class extends OriginalPosGlobalState {
        // @override
        async after_load_server_data() {
            for (var payment_method_id in this.payment_methods) {
                var payment_method = this.payment_methods[payment_method_id];
                if (
                    payment_method.use_payment_terminal === "oca_payment_terminal"
                ) {
                    this.config.use_proxy = true;
                }
            }
            return await super.after_load_server_data(...arguments);
        }
    };

const PosPaymentTerminalPayment = (OriginalPayment) =>
    class extends OriginalPayment {
        constructor() {
            console.log("jjjj")
            super(...arguments);
            // Id of the terminal transaction, used to find the payment
            // line corresponding to a terminal transaction status coming
            // from the terminal driver.
            this.terminal_transaction_id = null;
            // Success: null: in progress, false: failed: true: succeeded
            this.terminal_transaction_success = null;
            // Human readable transaction status, set if the transaction failed.
            this.terminal_transaction_status = null;
            // Additional information about the transaction status.
            this.terminal_transaction_status_details = null;
        }
        // @override
        init_from_JSON(json) {
            super.init_from_JSON(json);
            this.terminal_transaction_id = json.terminal_transaction_id;
            this.terminal_transaction_success = json.terminal_transaction_success;
            this.terminal_transaction_status = json.terminal_transaction_status;
            this.terminal_transaction_status_details =
                json.terminal_transaction_status_details;
        }
        // @override
        export_as_JSON() {
            var vals = super.export_as_JSON();
            vals.terminal_transaction_id = this.terminal_transaction_id;
            vals.terminal_transaction_success = this.terminal_transaction_success;
            vals.terminal_transaction_status_details =
                this.terminal_transaction_status_details;
            return vals;
        }
    };
