/** @odoo-module **/
import { jsonrpc } from "@web/core/network/rpc_service";
import publicWidget from "@web/legacy/js/public/public_widget";
import animations from "@website/js/content/snippets.animation";
publicWidget.registry.BestProduct = animations.Animation.extend({
    // To extend public widget
        selector: '.best_products_carousel',
         start: async function () {
        // To get data from controller.
        var self = this;
        await jsonrpc('/get_product_snippet', {}).then(function(data) {
            if (data) {
                        self.$target.empty().append(data);
                        self.product_carousel();
                    }
        })
    },
     product_carousel: function(autoplay = false, items = 4, slider_timing = 5000) {
            var self = this;
            this.$("#product").owlCarousel({
                items: 3,
                loop: true,
                margin: 30,
                stagePadding: 30,
                smartSpeed: 450,
                autoplay: true,
                autoPlaySpeed: 1000,
                autoPlayTimeout: 1000,
                autoplayHoverPause: true,
                dots: true,
                nav: true,
                navText: ['<i class="fa fa-angle-left" aria-hidden="false"></i>', '<i class="fa fa-angle-right" aria-hidden="false"></i>'],
                responsiveClass: true,
                responsive: {
                    0: {
                        items: 1,
                        nav: true
                    },
                    600: {
                        items: 2,
                        nav: true,
                    },
                    1000: {
                        items: 4,
                        nav: true,
                        loop: true,
                    }
                }
            });
        },
         counter: function() {
            var buttons = this.$('.owl-dots button');
            buttons.each(function(index, item) {});
        }
        })
